gPlayers = {} -- table contains all valid players, true for moderator and false for non-moderator
gOnline = {} -- moderators who have initialized their script (meant for player tracking)

gMuted = {} -- muted chat players [player] = {timer,duration}
gBans = {} -- [ip] = true

-- player tracking
RegisterLocalEventHandler("PlayerDropped",function(player)
	gOnline[player] = nil
	if gPlayers[player] then
		local id = GetPlayerId(player)
		for player in pairs(gOnline) do
			SendNetworkEvent(player,"moderator_tools:SetPlayer",id)
		end
		gPlayers[player] = nil
	end
	gMuted[player] = nil
end)
RegisterLocalEventHandler("PlayerConnected",function(player)
	local id,name = GetPlayerId(player),GetPlayerName(player)
	for player in pairs(gOnline) do
		SendNetworkEvent(player,"moderator_tools:SetPlayer",id,name)
	end
	F_UpdatePlayerModerator(player)
end)
RegisterLocalEventHandler("PlayerConnecting",function(player)
	if gBans[GetPlayerIp(player)] then
		KickPlayer(player,"You are banned.")
	end
end)

-- chat event
RegisterLocalEventHandler("chat:SendMessage",function(player,message)
	local mute = gMuted[player]
	if mute then
		if GetAccurateTimer() - mute[1] < mute[2] then
			return true
		end
		gMuted[player] = nil
	end
end)

-- network events
RegisterNetworkEventHandler("moderator_tools:RequestPermission",function(player)
	if gPlayers[player] then
		local players = {}
		for player in pairs(gPlayers) do
			players[GetPlayerId(player)] = GetPlayerName(player)
		end
		if next(players) then
			SendNetworkEvent(player,"moderator_tools:SetPlayers",players)
		end
		SendNetworkEvent(player,"moderator_tools:GivePermission")
		gOnline[player] = true
	end
end)
RegisterNetworkEventHandler("moderator_tools:WarnPlayer",function(player,id,text)
	if gPlayers[player] and type(text) == "string" then
		local target = F_GetPlayerById(id)
		if target then
			SendNetworkEvent(target,"moderator_tools:DisplayWarning",text)
			SendNetworkEvent(player,"moderator_tools:CommandResponse","warned "..GetPlayerName(target))
		else
			SendNetworkEvent(player,"moderator_tools:CommandResponse")
		end
	end
end)
RegisterNetworkEventHandler("moderator_tools:MutePlayer",function(player,id,minutes)
	if gPlayers[player] and (minutes == nil or type(minutes) == "number") then
		local target = F_GetPlayerById(id)
		if not target then
			SendNetworkEvent(player,"moderator_tools:CommandResponse")
		elseif minutes then
			SendNetworkEvent(target,"moderator_tools:NotifyMuted",minutes)
			SendNetworkEvent(player,"moderator_tools:CommandResponse","muted "..GetPlayerName(target).." for "..minutes.." minute(s)")
			gMuted[target] = {GetAccurateTimer(),minutes*60000}
		elseif gMuted[target] then
			SendNetworkEvent(target,"moderator_tools:NotifyMuted")
			SendNetworkEvent(player,"moderator_tools:CommandResponse","unmuted "..GetPlayerName(target))
			gMuted[target] = nil
		else
			SendNetworkEvent(player,"moderator_tools:CommandResponse",GetPlayerName(target).." was not muted")
		end
	end
end)
RegisterNetworkEventHandler("moderator_tools:KickPlayer",function(player,id,reason)
	if gPlayers[player] and type(reason) == "string" then
		local target = F_GetPlayerById(id)
		if target then
			SendNetworkEvent(player,"moderator_tools:CommandResponse","kicked "..GetPlayerName(target))
			KickPlayer(target,reason)
		else
			SendNetworkEvent(player,"moderator_tools:CommandResponse")
		end
	end
end)
RegisterNetworkEventHandler("moderator_tools:BanAccount",function(player,id,days)
	if gPlayers[player] and type(days) == "number" then
		local target = F_GetPlayerById(id)
		if target and not F_ShouldProtectPlayer(target) then
			-- not implemented
		else
			SendNetworkEvent(player,"moderator_tools:CommandResponse")
		end
	end
end)
RegisterNetworkEventHandler("moderator_tools:BanIp",function(player,id)
	if gPlayers[player] then
		local target = F_GetPlayerById(id)
		if target and not F_ShouldProtectPlayer(target) then
			gBans[GetPlayerIp(target)] = true
			SendNetworkEvent(player,"moderator_tools:CommandResponse","banned "..GetPlayerName(target).." (by ip)")
			KickPlayer(target,"You have been banned.")
			F_SaveBanList()
		else
			SendNetworkEvent(player,"moderator_tools:CommandResponse")
		end
	end
end)

-- utility functions
function F_ShouldProtectPlayer(player)
	return DoesPlayerHaveRole(player,"admin") or F_DoesPlayerHaveModerator(player)
end
function F_DoesPlayerHaveModerator(player)
	for role in AllConfigStrings(GetScriptConfig(),"mod_role") do
		if DoesPlayerHaveRole(player,role) then
			return true
		end
	end
	return false
end
function F_UpdatePlayerModerator(player)
	gPlayers[player] = F_DoesPlayerHaveModerator(player)
end
function F_GetPlayerById(id)
	for player in AllPlayers() do
		if GetPlayerId(player) == id then
			return player
		end
	end
end
function F_LoadBanList()
	local file,bytes = OpenFile("bans.txt","rb")
	if bytes > 0 then
		for _,ip in string.gfind(ReadFile(file,bytes),"([^\r\n]+)") do
			gBans[ip] = true
		end
	end
	CloseFile(file)
end
function F_SaveBanList()
	local sorted = {}
	local file = OpenFile("bans.txt","wb")
	for ip in pairs(gBans) do
		table.insert(sorted,ip)
	end
	table.sort(sorted)
	for _,ip in ipairs(sorted) do
		WriteFile(file,ip.."\r\n")
	end
	CloseFile(file)
end

-- existing players
for player in AllPlayers() do
	F_UpdatePlayerModerator(player)
end

-- load bans
F_LoadBanList()
